<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Schema;

class Installer
{

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        try {
            $installed = Schema::hasTable("account");
        }catch (\Exception $exception){
            if(in_array($exception->getCode(), [1044, 1045, 2002])){
                $installed = false;
            }else{
                throw $exception;
            }
        }

        if(!$installed){
            //系统未安装
            header('Location: ' . url('installer'));
            exit();
        }
        return $next($request);
    }

}
