<?php

namespace App\Http\Controllers\App;

use App\Http\Controllers\Controller;
use App\Utils\WeModule;
use Illuminate\Http\Request;

class ModuleController extends Controller
{
    //

    public function entry(Request $request, $moduleName, $do='index'){
        $WeModule = new WeModule();
        try {
            $site = $WeModule->create($moduleName);
        }catch (\Exception $exception){
            return $this->message('模块初始化失败，请联系技术处理');
        }
        $method = "doMobile" . ucfirst($do);
        if (!method_exists($site,$method)){
            return $this->message("模块不支持{$method}()方法");
        }
        return $site->$method($request);
    }

    /**
     * @throws \Exception
     */
    public function Api(Request $request, $moduleName, $route=""){
        define('IN_API', true);
        global $_W;
        $_W['isapi'] = true;
        $WeModule = new WeModule();
        //判断模块权限，待完善
        try {
            $site = $WeModule->create($moduleName);
            $method = "doMobileApi";
            if(!empty($route)){
                $_method = "doApi" . ucfirst($route);
                if (method_exists($site, $_method)){
                    $method = $_method;
                }else{
                    global $_GPC;
                    $_GPC['route'] = $route;
                }
            }
            if (!method_exists($site,$method)){
                return $this->message("模块不支持$method()方法");
            }
            return $site->$method($request);
        }catch (\Exception $exception){
            if ($_W['config']['debugMode'] || DEVELOPMENT){
                throw $exception;
            }
            return $this->message("请求失败(".$exception->getCode().")");
        }
    }

}
